<?php
/* * *******************************************************************************
 * The content of this file is subject to the PDF Maker license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is IT-Solutions4You s.r.o.
 * Portions created by IT-Solutions4You s.r.o. are Copyright(C) IT-Solutions4You s.r.o.
 * All Rights Reserved.
 * ****************************************************************************** */

class PDFMaker {

    private $version_type;
    private $license_key;
    private $version_no;
    private $basicModules;
    private $pageFormats;

    var $log;
    var $db;

    // constructor of PDFMaker class
    function __construct() {
        $this->log = LoggerManager::getLogger('account');
        $this->db = PearDatabase::getInstance();

        $this->setLicenseInfo();
        // array of modules that are allowed for basic version type
        $this->basicModules = array("20", "21", "22", "23");

        $this->name = "PDFMaker";
        $this->id = getTabId("PDFMaker");
    }

    
    function vtlib_handler($modulename, $event_type) {
        switch ($event_type) {
            case 'module.postinstall':
                $this->executeSql();
                break;
            case 'module.preupdate':
                break;
            case 'module.postupdate':
                $this->db->pquery("UPDATE vtiger_links SET linkurl = ?  WHERE linklabel = ? AND linktype = ? AND linkurl = ?", array('layouts/vlayout/modules/PDFMaker/resources/PDFMakerActions.js', 'PDFMakerJS', 'HEADERSCRIPT', 'modules/PDFMaker/PDFMakerActions.js'));
                $this->db->pquery("UPDATE vtiger_links SET linktype = ? , linkurl = ?  WHERE linklabel = ? AND linktype = ? AND linkurl = ? ", array('DETAILVIEWSIDEBARWIDGET','module=PDFMaker&view=GetPDFActions&record=$'.'RECORD$', 'PDFMaker', 'DETAILVIEWWIDGET', 'module=PDFMaker&action=PDFMakerAjax&file=getPDFActions&record=$'.'RECORD$'));
                break;
            case 'module.preuninstall':
                $this->removeLinks();
                break;
            case 'module.enabled':
                break;
        }
    }

    public function executeSql() {
        if ($this->db->num_rows($this->db->pquery("SELECT id FROM vtiger_pdfmaker_seq", array())) < 1) {
            $this->db->pquery("INSERT INTO vtiger_pdfmaker_seq VALUES (?)", array('0'));
        }

        $productblocData = "INSERT INTO `vtiger_pdfmaker_productbloc_tpl` (`id`, `name`, `body`) VALUES
					(1, 'Product block for group tax', 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),
					(2, 'Product block for individual tax', 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)";
        $this->db->pquery($productblocData, array());

        $pdfmakerData = "INSERT INTO `vtiger_pdfmaker` (`templateid`, `filename`, `module`, `body`, `description`, `deleted`) VALUES
				(1, 'Invoice', 'Invoice', 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, 'Template for Invoice', 0),
				(2, 'SalesOrder', 'SalesOrder', 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, 'Template for SalesOrder', 0),
				(3, 'PurchaseOrder', 'PurchaseOrder', 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, 'Template for PurchaseOrder', 0),
				(4, 'Quotes', 'Quotes', 0x3c703e0d0a093c696d6720616c743d2222207372633d22687474703a2f2f64656d6f2e76746967657263726d2e736b2f746573742f2f6c6f676f2f6c6f676f2d6974732e6a706722202f3e3c6272202f3e0d0a09266e6273703b3c2f703e0d0a3c7461626c6520626f726465723d2230222063656c6c70616464696e673d2231222063656c6c73706163696e673d223122207374796c653d22666f6e742d66616d696c793a2056657264616e613b222073756d6d6172793d22222077696474683d2231303025223e0d0a093c74626f64793e0d0a09093c74723e0d0a09093c2f74723e0d0a09093c74723e0d0a0909093c746420616c69676e3d226c656674222076616c69676e3d22746f70222077696474683d22353025223e0d0a090909093c666f6e742073697a653d2232223e3c666f6e742073697a653d2234223e3c7370616e207374796c653d22666f6e742d7765696768743a20626f6c643b223e2451554f5445535f4143434f554e545f4944243c2f7370616e3e3c2f666f6e743e3c6272202f3e0d0a090909093c6272202f3e0d0a090909092451554f5445535f42494c4c5f535452454554243c2f666f6e743e3c6272202f3e0d0a090909093c666f6e742073697a653d2232223e2451554f5445535f42494c4c5f434f444524202451554f5445535f42494c4c5f43495459243c2f666f6e743e3c6272202f3e0d0a090909093c666f6e742073697a653d2232223e2451554f5445535f42494c4c5f5354415445243c2f666f6e743e3c2f74643e0d0a0909093c74642077696474683d22353025223e0d0a090909093c703e0d0a09090909093c7370616e207374796c653d22666f6e742d7765696768743a20626f6c643b223e24434f4d50414e595f4e414d45243c2f7370616e3e3c2f703e0d0a090909093c703e0d0a090909090924434f4d50414e595f41444452455353243c6272202f3e0d0a090909090924434f4d50414e595f5a4950242024434f4d50414e595f43495459243c6272202f3e0d0a090909090924434f4d50414e595f434f554e545259243c2f703e0d0a090909093c703e0d0a090909090954656c65666f6e2024434f4d50414e595f50484f4e45243c6272202f3e0d0a090909090954656c656661782024434f4d50414e595f464158243c6272202f3e0d0a09090909093c6272202f3e0d0a090909090924434f4d50414e595f57454253495445243c6272202f3e0d0a09090909093c6272202f3e0d0a0909090909254d5f56616c69642054696c6c253a202451554f5445535f56414c494454494c4c243c2f703e0d0a0909093c2f74643e0d0a09093c2f74723e0d0a093c2f74626f64793e0d0a3c2f7461626c653e0d0a3c703e0d0a093c666f6e742073697a653d2235223e3c666f6e74207374796c653d22666f6e742d7765696768743a20626f6c643b20666f6e742d66616d696c793a2056657264616e613b223e254d5f51756f7465204e6f25202451554f5445535f51554f54455f4e4f243c2f666f6e743e3c2f666f6e743e3c2f703e0d0a3c7461626c6520626f726465723d2231222063656c6c70616464696e673d2233222063656c6c73706163696e673d223022207374796c653d22666f6e742d73697a653a313070783b222077696474683d2231303025223e0d0a093c74686561643e0d0a09093c7472206267636f6c6f723d2223633063306330223e0d0a0909093c7464207374796c653d22544558542d414c49474e3a2063656e746572223e0d0a090909093c7370616e3e3c7374726f6e673e506f733c2f7374726f6e673e3c2f7370616e3e3c2f74643e0d0a0909093c746420636f6c7370616e3d223222207374796c653d22544558542d414c49474e3a2063656e746572223e0d0a090909093c7370616e3e3c7374726f6e673e25475f517479253c2f7374726f6e673e3c2f7370616e3e3c2f74643e0d0a0909093c7464207374796c653d22544558542d414c49474e3a2063656e746572223e0d0a090909093c7370616e3e3c7370616e207374796c653d22666f6e742d7765696768743a20626f6c643b223e546578743c2f7370616e3e3c2f7370616e3e3c2f74643e0d0a0909093c7464207374796c653d22544558542d414c49474e3a2063656e746572223e0d0a090909093c7370616e3e3c7374726f6e673e25475f4c424c5f4c4953545f5052494345253c6272202f3e0d0a090909093c2f7374726f6e673e3c2f7370616e3e3c2f74643e0d0a0909093c7464207374796c653d22746578742d616c69676e3a2063656e7465723b223e0d0a090909093c7374726f6e673e25475f537562746f74616c253c2f7374726f6e673e3c2f74643e0d0a0909093c7464207374796c653d22544558542d414c49474e3a2063656e746572223e0d0a090909093c7370616e3e3c7374726f6e673e25475f446973636f756e74253c2f7374726f6e673e3c2f7370616e3e3c2f74643e0d0a0909093c7464207374796c653d22544558542d414c49474e3a2063656e746572223e0d0a090909093c7370616e3e3c7374726f6e673e25475f4c424c5f4e45545f5052494345253c6272202f3e0d0a09090909776974686f7574205441583c6272202f3e0d0a090909093c2f7374726f6e673e3c2f7370616e3e3c2f74643e0d0a0909093c7464207374796c653d22746578742d616c69676e3a2063656e7465723b223e0d0a090909093c7370616e3e3c7374726f6e673e25475f54617825202825293c2f7374726f6e673e3c2f7370616e3e3c2f74643e0d0a0909093c7464207374796c653d22746578742d616c69676e3a2063656e7465723b223e0d0a090909093c7370616e3e3c7374726f6e673e25475f546178253c2f7374726f6e673e20283c7374726f6e673e2443555252454e4359434f4445243c2f7374726f6e673e293c2f7370616e3e3c2f74643e0d0a0909093c7464207374796c653d22746578742d616c69676e3a2063656e7465723b223e0d0a090909093c7370616e3e3c7374726f6e673e254d5f546f74616c253c2f7374726f6e673e3c2f7370616e3e3c2f74643e0d0a09093c2f74723e0d0a093c2f74686561643e0d0a093c74626f64793e0d0a09093c74723e0d0a0909093c746420636f6c7370616e3d223131223e0d0a090909092350524f44554354424c4f435f5354415254233c2f74643e0d0a09093c2f74723e0d0a09093c74723e0d0a0909093c7464207374796c653d22746578742d616c69676e3a2063656e7465723b20766572746963616c2d616c69676e3a20746f703b223e0d0a090909092450524f44554354504f534954494f4e243c2f74643e0d0a0909093c746420616c69676e3d227269676874222076616c69676e3d22746f70223e0d0a090909092450524f445543545155414e54495459243c2f74643e0d0a0909093c746420616c69676e3d226c65667422207374796c653d22544558542d414c49474e3a2063656e746572222076616c69676e3d22746f70223e0d0a090909092450524f445543545553414745554e4954243c2f74643e0d0a0909093c746420616c69676e3d226c656674222076616c69676e3d22746f70223e0d0a090909092450524f445543544e414d45243c2f74643e0d0a0909093c746420616c69676e3d22726967687422207374796c653d22746578742d616c69676e3a2072696768743b222076616c69676e3d22746f70223e0d0a090909092450524f445543544c4953545052494345243c2f74643e0d0a0909093c746420616c69676e3d22726967687422207374796c653d22544558542d414c49474e3a207269676874222076616c69676e3d22746f70223e0d0a090909092450524f44554354544f54414c243c2f74643e0d0a0909093c746420616c69676e3d22726967687422207374796c653d22544558542d414c49474e3a207269676874222076616c69676e3d22746f70223e0d0a090909092450524f44554354444953434f554e54243c2f74643e0d0a0909093c746420616c69676e3d22726967687422207374796c653d22746578742d616c69676e3a2072696768743b222076616c69676e3d22746f70223e0d0a090909092450524f4455435453544f54414c4146544552444953434f554e54243c2f74643e0d0a0909093c746420616c69676e3d22726967687422207374796c653d22746578742d616c69676e3a2072696768743b222076616c69676e3d22746f70223e0d0a090909092450524f4455435456415450455243454e54243c2f74643e0d0a0909093c746420616c69676e3d22726967687422207374796c653d22746578742d616c69676e3a2072696768743b222076616c69676e3d22746f70223e0d0a090909092450524f4455435456415453554d243c2f74643e0d0a0909093c746420616c69676e3d22726967687422207374796c653d22544558542d414c49474e3a207269676874222076616c69676e3d22746f70223e0d0a090909092450524f44554354544f54414c53554d243c2f74643e0d0a09093c2f74723e0d0a09093c74723e0d0a0909093c746420636f6c7370616e3d223131223e0d0a090909092350524f44554354424c4f435f454e44233c2f74643e0d0a09093c2f74723e0d0a09093c74723e0d0a0909093c746420636f6c7370616e3d223722207374796c653d22544558542d414c49474e3a206c656674223e0d0a09090909537562746f74616c733c2f74643e0d0a0909093c7464207374796c653d22544558542d414c49474e3a207269676874223e0d0a090909093c7370616e207374796c653d22746578742d616c69676e3a2072696768743b20223e24544f54414c574954484f5554564154243c2f7370616e3e3c2f74643e0d0a0909093c7464207374796c653d22544558542d414c49474e3a207269676874223e0d0a09090909266e6273703b3c2f74643e0d0a0909093c7464207374796c653d22544558542d414c49474e3a207269676874223e0d0a090909093c7370616e207374796c653d22746578742d616c69676e3a2072696768743b20223e24564154243c2f7370616e3e3c2f74643e0d0a0909093c7464207374796c653d22544558542d414c49474e3a207269676874223e0d0a0909090924535542544f54414c243c2f74643e0d0a09093c2f74723e0d0a09093c74723e0d0a0909093c746420636f6c7370616e3d22313022207374796c653d22544558542d414c49474e3a206c656674223e0d0a0909090925475f446973636f756e74253c2f74643e0d0a0909093c7464207374796c653d22544558542d414c49474e3a207269676874223e0d0a0909090924544f54414c444953434f554e54243c2f74643e0d0a09093c2f74723e0d0a09093c74723e0d0a0909093c746420636f6c7370616e3d22313022207374796c653d22544558542d414c49474e3a206c656674223e0d0a09090909546f74616c2077697468205441583c2f74643e0d0a0909093c7464207374796c653d22544558542d414c49474e3a207269676874223e0d0a0909090924544f54414c57495448564154243c2f74643e0d0a09093c2f74723e0d0a09093c74723e0d0a0909093c746420636f6c7370616e3d22313022207374796c653d22746578742d616c69676e3a206c6566743b223e0d0a0909090925475f4c424c5f5348495050494e475f414e445f48414e444c494e475f43484152474553253c2f74643e0d0a0909093c7464207374796c653d22746578742d616c69676e3a2072696768743b223e0d0a09090909245348544158414d4f554e54243c2f74643e0d0a09093c2f74723e0d0a09093c74723e0d0a0909093c746420636f6c7370616e3d22313022207374796c653d22544558542d414c49474e3a206c656674223e0d0a0909090925475f4c424c5f5441585f464f525f5348495050494e475f414e445f48414e444c494e47253c2f74643e0d0a0909093c7464207374796c653d22544558542d414c49474e3a207269676874223e0d0a09090909245348544158544f54414c243c2f74643e0d0a09093c2f74723e0d0a09093c74723e0d0a0909093c746420636f6c7370616e3d22313022207374796c653d22544558542d414c49474e3a206c656674223e0d0a0909090925475f41646a7573746d656e74253c2f74643e0d0a0909093c7464207374796c653d22544558542d414c49474e3a207269676874223e0d0a090909092441444a5553544d454e54243c2f74643e0d0a09093c2f74723e0d0a09093c74723e0d0a0909093c746420636f6c7370616e3d22313022207374796c653d22544558542d414c49474e3a206c656674223e0d0a090909093c7370616e207374796c653d22666f6e742d7765696768743a20626f6c643b223e25475f4c424c5f4752414e445f544f54414c25203c2f7370616e3e3c7374726f6e673e282443555252454e4359434f444524293c2f7374726f6e673e3c2f74643e0d0a0909093c7464206e6f777261703d226e6f7772617022207374796c653d22544558542d414c49474e3a207269676874223e0d0a090909093c7374726f6e673e24544f54414c243c2f7374726f6e673e3c2f74643e0d0a09093c2f74723e0d0a093c2f74626f64793e0d0a3c2f7461626c653e0d0a3c703e0d0a09266e6273703b3c2f703e0d0a3c703e0d0a092451554f5445535f5445524d535f434f4e444954494f4e53243c2f703e0d0a, 'Templates for Quotes', 0)";

        $this->db->pquery($pdfmakerData, array());

        $settingsData = "INSERT INTO `vtiger_pdfmaker_settings` (`templateid`, `margin_top`, `margin_bottom`, `margin_left`, `margin_right`, `format`, `orientation`, `decimals`, `decimal_point`, `thousands_separator`, `header`, `footer`, `sharingtype`) VALUES
		            (2, 2.0, 2.0, 2.0, 2.0, 'A4', 'portrait', 2, ',', '', '<p>\r\n	##PAGE##/##PAGES##</p>\r\n', '<p style=\"text-align: center;\">\r\n	<span style=\"font-size:10px;\">$" . "COMPANY_NAME" . "$ <small>&bull; </small>$" . "COMPANY_ADDRESS" . "$ <small>&bull; </small> $" . "COMPANY_ZIP" . "$<small> </small>$" . "COMPANY_CITY" . "$<small> &bull; </small>$" . "COMPANY_STATE" . "$</span></p>\r\n','public'),
					(1, 2.0, 2.0, 2.0, 2.0, 'A4', 'portrait', 2, ',', '', '<p>\r\n	##PAGE##/##PAGES##</p>\r\n', '<p style=\"text-align: center;\">\r\n	<span style=\"font-size:10px;\">$" . "COMPANY_NAME" . "$ <small>&bull; </small>$" . "COMPANY_ADDRESS" . "$ <small>&bull; </small> $" . "COMPANY_ZIP" . "$<small> </small>$" . "COMPANY_CITY" . "$<small> &bull; </small>$" . "COMPANY_STATE" . "$</span></p>\r\n','public'),
					(3, 2.0, 2.0, 2.0, 2.0, 'A4', 'portrait', 2, ',', '', '<p>\r\n	##PAGE##/##PAGES##</p>\r\n', '<p style=\"text-align: center;\">\r\n	<span style=\"font-size:10px;\">$" . "COMPANY_NAME" . "$ <small>&bull; </small>$" . "COMPANY_ADDRESS" . "$ <small>&bull; </small> $" . "COMPANY_ZIP" . "$<small> </small>$" . "COMPANY_CITY" . "$<small> &bull; </small>$" . "COMPANY_STATE" . "$</span></p>\r\n','public'),
					(4, 2.0, 2.0, 2.0, 2.0, 'A4', 'portrait', 2, ',', '', '<p>\r\n	##PAGE##/##PAGES##</p>\r\n', '<p style=\"text-align: center;\">\r\n	<span style=\"font-size:10px;\">$" . "COMPANY_NAME" . "$ <small>&bull; </small>$" . "COMPANY_ADDRESS" . "$ <small>&bull; </small> $" . "COMPANY_ZIP" . "$<small> </small>$" . "COMPANY_CITY" . "$<small> &bull; </small>$" . "COMPANY_STATE" . "$</span></p>\r\n','public')";
        $this->db->pquery($settingsData, array());

        $seqUpdate = "UPDATE vtiger_pdfmaker_seq SET id = ? WHERE id = ?";
        $this->db->pquery($seqUpdate, array('4','0'));

        $this->AddLinks("Quotes");
        $this->AddLinks("SalesOrder");
        $this->AddLinks("PurchaseOrder");
        $this->AddLinks("Invoice");

        $this->db->pquery("INSERT INTO vtiger_pdfmaker_releases (version, date, updated) VALUES (?, NOW(), 1)", array(PDFMaker_Version_Helper::$version));
    }
    
    public function AddLinks($modulename) {
        require_once('vtlib/Vtiger/Module.php');
        $link_module = Vtiger_Module::getInstance($modulename);
        $link_module->addLink('DETAILVIEWSIDEBARWIDGET', 'PDFMaker', 'module=PDFMaker&view=GetPDFActions&record=$RECORD$');
        
        global $adb;
        $tabid = getTabId($modulename);
        $res = $adb->pquery("SELECT * FROM vtiger_links WHERE tabid=? AND linktype=? AND linklabel=? AND linkurl=? ORDER BY linkid DESC", array($tabid, 'DETAILVIEWWIDGET', 'PDFMaker', 'module=PDFMaker&action=PDFMakerAjax&file=getPDFActions&record=$RECORD$'));
        $i = 0;
        while ($row = $adb->fetchByAssoc($res)) {
            $i++;
            if ($i > 1)
                $adb->pquery("DELETE FROM vtiger_links WHERE linkid=?", array($row['linkid']));
        }
    }
    
   
    public function removeLinks() {
        require_once('vtlib/Vtiger/Link.php');

        $tabid = getTabId("PDFMaker");
        Vtiger_Link::deleteAll($tabid);
        $this->DeleteAllRefLinks();
    }
    
    public function DeleteAllRefLinks() {
        require_once('vtlib/Vtiger/Link.php');
        
        foreach ($this->basicModules AS $tabid) {
            Vtiger_Link::deleteLink($tabid, "DETAILVIEWWIDGET", "PDFMaker");
        }
    }
    
    //PRIVATE METHODS SECTION
    private function setLicenseInfo() {

        $this->version_no = PDFMaker_Version_Helper::$version;
        $this->version_type = "Free";
    }
    
    //Getters and Setters
    public function GetVersionType() {
        return $this->version_type;
    }

    public function GetLicenseKey() {
        return $this->license_key;
    }

    public function GetPageFormats() {
        return $this->pageFormats;
    }

    public function GetBasicModules() {
        return $this->basicModules;
    }
}      